#include <iostream>
#include <vector>
#include <unordered_set>

int nzd(int a, int b)
{
	return b == 0 ? a : nzd(b, a % b); 
}

std::vector<int> divisors(int n)
{
	std::vector<int> ret;
	
	int i;
	for(i = 1; i * i < n; i++)
		if(n % i == 0)
			ret.push_back(i);
		
	if(i - (n / i) == 1)
		i--;
	
	for(; i >= 1; i--)
		if(n % i == 0)
			ret.push_back(n / i);
	
	return ret;
}

int main()
{
	int q;
	
	std::cin >> q;
	
	for(int i = 0; i < q; i++)
	{
		int n;
		std::cin >> n;
		
		std::vector<int> cards;
		std::unordered_set<int> unique;
		cards.push_back(2);
		unique.insert(2);
		
		for(int j = 2; j < n; j++)
		{
			if(cards.size() >= n)
				break;
			
			int tmp = 2 * j;
			if(tmp > n)
				break;
			
			cards.push_back(tmp);
			unique.insert(tmp);
		}
		
		for(int j = cards.size() - 1; j >= 0; j--)
		{
			if(cards[j] < 5)
				break;
			
			auto div = divisors(cards[j]);
			for(int d : div)
			{
				if(cards.size() >= n)
					break;
				if(nzd(d, cards[j]) > 1)
				{
					unique.insert(d);
				}
			}
			
		}
		
		std::cout << unique.size() << "\n";
	}
	
	return 0;
}